#include "options.h"

#include "t_pwuid.h"
#include "t_pwname.h"
#include "t_grgid.h"
#include "t_grname.h"
#include "t_grouplist.h"

#include <security/libs/cpp/log/log.h>
#include <util/system/datetime.h>
#include <util/string/cast.h>


using namespace NCAuth::NStress;

namespace {
    class TTimer {
    public:
        TTimer() : StartTime(TInstant::Now()) {};

        [[nodiscard]] TDuration Elapsed() const {
            return TInstant::Now() - StartTime;
        }

    private:
        TInstant StartTime;
    };

    void run(ETestKind kind, const TProgramOptions& opts) {
        try {
            TTimer timer;
            switch (kind) {
                case ETestKind::PwUid:
                    testPwUid(opts.Count, FromString<ui32>(opts.Arg));
                    break;
                case ETestKind::PwName:
                    testPwName(opts.Count, opts.Arg);
                    break;
                case ETestKind::GrGid:
                    testGrGid(opts.Count, FromString<ui32>(opts.Arg));
                    break;
                case ETestKind::GrName:
                    testGrName(opts.Count, opts.Arg);
                    break;
                case ETestKind::GrList:
                    testGroupList(opts.Count, opts.Arg);
                    break;
                default:
                    ythrow TSystemError() << "unexpected event kind: " << opts.TestKind;
            }

            Cout << "Finished " << opts.Count << " passes of '" << opts.TestKind << "' in " << timer.Elapsed() << Endl;
        } catch (const yexception& e) {
            NSecurityHelpers::LogErr("Test failed", "err", e.AsStrBuf());
        }
    }
}  // anonymous

int main(int argc, char** argv) {
    auto opts = TProgramOptions::Parse(argc, argv);

    run(opts.TestKind, opts);
    return 0;
}
