#include "options.h"

#include <util/string/cast.h>
#include <util/generic/serialized_enum.h>
#include <library/cpp/getopt/last_getopt.h>


namespace NCAuth::NStress {

const TProgramOptions TProgramOptions::Parse(int argc, char** argv) {
    auto options = TProgramOptions();

    using namespace NLastGetopt;
    TOpts opts = TOpts::Default();

    opts.SetTitle("NSS stress test");

    opts.AddLongOption("count", "passes count")
        .DefaultValue(1000)
        .StoreResult(&options.Count);

    opts.AddLongOption("type", "test type: " + GetEnumAllNames<ETestKind>())
        .DefaultValue(ToString(ETestKind::PwName));

    TOptsParseResult args(&opts, argc, argv);

    options.TestKind = FromString<ETestKind>(args.Get("type"));
    options.Arg = "buglloc";
    if (args.GetFreeArgCount() > 0) {
        options.Arg = args.GetFreeArgs()[0];
    }
    return options;
}

}  // namespace NCAuth::NStress
