#pragma once

#include <util/generic/string.h>

namespace NCAuth::NStress {

enum ETestKind : ui32 {
    PwName /* "pwnam" */,

    // execveat syscall
    PwUid /* "pwuid" */,

    // real process execution
    GrName /* "grnam" */,

    // getppid syscall
    GrGid /* "grgid" */,

    GrList /* "grlist" */,
};


class TProgramOptions {
public:
    int Count;
    ETestKind TestKind;
    TString Arg;

    static const TProgramOptions Parse(int argc, char** argv);

};

}  // namespace NCAuth::NStress
