#include "t_grouplist.h"

#include <pwd.h>
#include <grp.h>
#include <util/system/types.h>
#include <util/system/yassert.h>


int NCAuth::NStress::testGroupList(int count, const TString& login) {
    auto pw = getpwnam(login.c_str());
    Y_VERIFY(pw);

    int ngroups = 10;
    gid_t* groups = (gid_t*) std::malloc(sizeof(*groups) * ngroups);
    Y_VERIFY(groups);

    for (int i = 0; i < count; ++i) {
        getgrouplist(pw->pw_name, pw->pw_gid, groups, &ngroups);
        Y_VERIFY(ngroups > 0);
    }
    return count;
}
