package main

import (
	"math/rand"
	"os"
	"runtime"
	"time"

	"a.yandex-team.ru/infra/cauth/agent/linux/yandex-cauth-userd/internal/commands"
	"a.yandex-team.ru/library/go/maxprocs"
)

const (
	goMaxProcs = 4
)

func adjustGoMaxProcs() {
	if _, ok := os.LookupEnv(maxprocs.GoMaxProcEnvName); ok {
		return
	}

	runtime.GOMAXPROCS(goMaxProcs)
}

func main() {
	adjustGoMaxProcs()
	rand.Seed(time.Now().UnixNano())
	commands.Main()
}
