package app

import (
	"fmt"
	"net/http"
	"time"

	"github.com/go-chi/chi/v5/middleware"

	"a.yandex-team.ru/library/go/core/log"
)

func logRequest(l log.Logger, m *metrics) func(http.Handler) http.Handler {
	return func(next http.Handler) http.Handler {
		fn := func(w http.ResponseWriter, r *http.Request) {
			start := time.Now()
			ww := middleware.NewWrapResponseWriter(w, r.ProtoMajor)
			defer func() {
				reqTime := time.Since(start)
				l.Debug(fmt.Sprintf("req: %s", r.RequestURI),
					log.String("uri", r.RequestURI),
					log.Int("status", ww.Status()),
					log.String("elapsed", reqTime.String()),
				)
				m.PutRequestDuration(reqTime)
				m.PutRequestStatus(ww.Status())
			}()
			next.ServeHTTP(ww, r)
		}
		return http.HandlerFunc(fn)
	}
}
