package cauth

import (
	"encoding/json"
	"fmt"
	"io"
)

type KeysInfo struct {
	InsecureCAListURL string   `json:"insecure_ca_list_url"`
	SudoCAListURL     string   `json:"sudo_ca_list_url"`
	KrlURL            string   `json:"krl_url"`
	SecureCAListURL   string   `json:"secure_ca_list_url"`
	KeySources        []string `json:"key_sources"`
}

func ParseKeysInfo(r io.ReadCloser) (*KeysInfo, []byte, error) {
	var keysInfo KeysInfo
	defer r.Close()
	dec := json.NewDecoder(r)
	if err := dec.Decode(&keysInfo); err == io.EOF {
		return nil, nil, fmt.Errorf("failed to parse: %w", err)
	} else if err != nil {
		return nil, nil, err
	}
	buf, err := json.Marshal(keysInfo)
	if err != nil {
		return nil, nil, err
	}
	return &keysInfo, buf, nil
}
