package passwd

import (
	"fmt"
	"io"
	"strconv"
	"strings"
)

type Group struct {
	Name    string
	GID     uint32
	Members []string
}

func ParseGroup(r io.ReadCloser) ([]*Group, error) {
	var groups []*Group
	defer r.Close()
	err := IterateLines(r, func(line []byte) error {
		// svc_hostmanager-walle_development:x:237391:mixas,warwish
		parts := strings.SplitN(string(line), ":", 4)
		if len(parts) < 4 || parts[0] == "" {
			return nil
		}
		gid, err := strconv.ParseUint(parts[2], 10, 32)
		if err != nil {
			return err
		}

		members := strings.Split(parts[3], ",")
		for i, member := range members {
			members[i] = strings.TrimSpace(member)
		}

		groups = append(groups, &Group{
			GID:     uint32(gid),
			Name:    parts[0],
			Members: members,
		})
		return nil
	})

	if err != nil {
		return nil, fmt.Errorf("parse failed: %w", err)
	}

	return groups, nil
}
