package passwd

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParseGroup(t *testing.T) {
	r := &readCloser{r: strings.NewReader(`######## HERE GROUP OF AUTHORIZED USERS FOR warwish-cauth-xenial.myt.yp-c.yandex.net ########
dpt_yandex:x:20001:albert-si,allazarev,alonger,altynbek,anttsov,bidzilya,bromigo,dimrul,disafonov,dmtrmonakhov,dstudentsov,dvsonin,earthling,efmv,ferenets,frolstas,i-dyachkov,ignat,kiranight23,max7255,naumbi4,nekto0n,noiseless,oleglatin,reddi,rocco66,romanovich,sivanichkin,svagalakov,tedkon,torkve,vaspahomov,warwish,wwfq,zeebdo,zeil
dpt_yandex_infra_tech_ytdev:x:20221:bidzilya,ignat
######## MD5:7bf92d22425860fd3bc9a4e15a82c536:####### REAL:man2-8435-3.w24ulrq6mhi77kul.man.yp-c.yandex.net:######`)}
	expected := []*Group{
		{
			Name:    "dpt_yandex",
			GID:     20001,
			Members: strings.Split("albert-si,allazarev,alonger,altynbek,anttsov,bidzilya,bromigo,dimrul,disafonov,dmtrmonakhov,dstudentsov,dvsonin,earthling,efmv,ferenets,frolstas,i-dyachkov,ignat,kiranight23,max7255,naumbi4,nekto0n,noiseless,oleglatin,reddi,rocco66,romanovich,sivanichkin,svagalakov,tedkon,torkve,vaspahomov,warwish,wwfq,zeebdo,zeil", ","),
		},
		{
			Name:    "dpt_yandex_infra_tech_ytdev",
			GID:     20221,
			Members: strings.Split("bidzilya,ignat", ","),
		},
	}
	groups, err := ParseGroup(r)
	assert.NoError(t, err)
	assert.Equal(t, expected, groups)
}
