package passwd

import (
	"fmt"
	"io"
	"strings"
)

type Key struct {
	Login string
	Key   string
}

func ParseKeys(r io.ReadCloser) ([]*Key, error) {
	var keys []*Key
	defer r.Close()
	err := IterateLines(r, func(line []byte) error {
		// username : line_for_authorized_keys
		parts := strings.SplitN(string(line), ":", 2)
		if len(parts) < 2 || parts[0] == "" {
			return nil
		}
		keys = append(keys, &Key{
			Login: strings.TrimSpace(parts[0]),
			Key:   strings.TrimSpace(parts[1]),
		})
		return nil
	})
	if err != nil {
		return nil, fmt.Errorf("faile to parse keys: %w", err)
	}
	return keys, nil
}
