package passwd

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestParseKeys(t *testing.T) {
	r := &readCloser{r: strings.NewReader(`######## KEYS FOR USERS FROM RULES FOR warwish-cauth-xenial.myt.yp-c.yandex.net ########
######## KEYS FOR SERVER ADMINS FOR HOST warwish-cauth-xenial.myt.yp-c.yandex.net ########
warwish : ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97
zeebdo : ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCwur++p/AXL0Xzf0EQhWld6UC2EAhjqSrnSKQFMKFM3HjAOlPxuOMp5PF3gfX5SS8MNSghDd5XJAIcDiNu9g2EB8esoQ8EGgbGxRknqhI0rACyxS01KUqPIIfwV3mCQENDRVPRRU9xfFAHe316tGt9kvG2n+PsdhYmiRWzad29U/+WTWFUf7j1Rg4u1wj9JWTxDEWwkC/6CsSV+De8NV90K6/jmq/WkW3t8eB6RJKY0078QgLPcUlQgwQ6i8khmyvw1TQH4Mr9WeANOBBl8arBHdzcZ/283Bwlvr6yHS4NbDrBmpdpvcIuQCfoI2u5utaQmFkg4e618vVJaHNGljWRdDvpTGauLiXiEBsG49Q4iA0FYMUvbD3Rv8ITUPMxeWvksNWlalkPWfn4wQFGEFHPzE7WcUY42xX9kByvGDcbZnc7WBlRkwI+IZyxrXM2XjcAzjcvJjUojbVq8InFD87QJTRODj1H3mLdYBo5c8QrbzVaaKfaevO3ZhU9/C4ksXU= zeebdo@zeebdo-nix
zeebdo : ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDzYnlABcLodd/xaZ67nYoETTtftweL9XwoEHFXgsWEBorDitlV1U2xU+BUnLdltr5AiQBmPxotYG028Zlah9T2Sn18yy4Z+YjcH3hxwYwB16e/mbgVdYWACT59TrTw78zQ57VhQGcaFImMSfPVTBINO6xXPlF4coNX0NjVJ74XNT8wF75+HP8SuqhEGSg0vrWfWejU1sCEt6XpR6HPN4GgAJ0D+Fib0UYVkI0yZ565pJccf5Asfzj2tvSt/jOlvQReo4i5gT4R2GbkEmBot0/8uTSSVy+TJvs2bjXmpM/Kb4Fb/FN8nF6ZAwVMRmH7fEXWn8j7LSBjN0S8CRFgdIpDpX07S8dNvJ4ISbjVT04B121jri7J9FscK8zQnohGEEUkfqeUUAk7zJmi/p26rlfVGqdnM041M/0iwNl+3yYmoDqBKfjqLgRqF9DSfTrZJS1OO6m/JG5bTl6w6xMVFtmVM0hcaSwpUo4CrRxYb+BFHJsr7gnuqnx9Fqwsg5n6L1k= zeebdo@zeebdo-nix
######## MD5:49499c18d1c6eaac8887f7bdd671e40d:####### REAL:myt1-2993-1.sico44uqicgpb2jx.myt.yp-c.yandex.net:######`)}
	expected := []*Key{
		{
			Login: "warwish",
			Key:   "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97",
		},
		{
			Login: "zeebdo",
			Key:   "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCwur++p/AXL0Xzf0EQhWld6UC2EAhjqSrnSKQFMKFM3HjAOlPxuOMp5PF3gfX5SS8MNSghDd5XJAIcDiNu9g2EB8esoQ8EGgbGxRknqhI0rACyxS01KUqPIIfwV3mCQENDRVPRRU9xfFAHe316tGt9kvG2n+PsdhYmiRWzad29U/+WTWFUf7j1Rg4u1wj9JWTxDEWwkC/6CsSV+De8NV90K6/jmq/WkW3t8eB6RJKY0078QgLPcUlQgwQ6i8khmyvw1TQH4Mr9WeANOBBl8arBHdzcZ/283Bwlvr6yHS4NbDrBmpdpvcIuQCfoI2u5utaQmFkg4e618vVJaHNGljWRdDvpTGauLiXiEBsG49Q4iA0FYMUvbD3Rv8ITUPMxeWvksNWlalkPWfn4wQFGEFHPzE7WcUY42xX9kByvGDcbZnc7WBlRkwI+IZyxrXM2XjcAzjcvJjUojbVq8InFD87QJTRODj1H3mLdYBo5c8QrbzVaaKfaevO3ZhU9/C4ksXU= zeebdo@zeebdo-nix",
		},
		{
			Login: "zeebdo",
			Key:   "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQDzYnlABcLodd/xaZ67nYoETTtftweL9XwoEHFXgsWEBorDitlV1U2xU+BUnLdltr5AiQBmPxotYG028Zlah9T2Sn18yy4Z+YjcH3hxwYwB16e/mbgVdYWACT59TrTw78zQ57VhQGcaFImMSfPVTBINO6xXPlF4coNX0NjVJ74XNT8wF75+HP8SuqhEGSg0vrWfWejU1sCEt6XpR6HPN4GgAJ0D+Fib0UYVkI0yZ565pJccf5Asfzj2tvSt/jOlvQReo4i5gT4R2GbkEmBot0/8uTSSVy+TJvs2bjXmpM/Kb4Fb/FN8nF6ZAwVMRmH7fEXWn8j7LSBjN0S8CRFgdIpDpX07S8dNvJ4ISbjVT04B121jri7J9FscK8zQnohGEEUkfqeUUAk7zJmi/p26rlfVGqdnM041M/0iwNl+3yYmoDqBKfjqLgRqF9DSfTrZJS1OO6m/JG5bTl6w6xMVFtmVM0hcaSwpUo4CrRxYb+BFHJsr7gnuqnx9Fqwsg5n6L1k= zeebdo@zeebdo-nix",
		},
	}
	keys, err := ParseKeys(r)
	assert.NoError(t, err)
	assert.Equal(t, expected, keys)
}
