package passwd

import (
	"fmt"
	"io"
	"strconv"
	"strings"
)

type User struct {
	UID     uint32
	GID     uint32
	Login   string
	HomeDir string
	Shell   string
	Gecos   string
}

func ParsePasswd(r io.ReadCloser) ([]*User, error) {
	var users []*User
	defer r.Close()
	err := IterateLines(r, func(line []byte) error {
		// alonger:*:31592:87443:alonger:/home/alonger:/bin/bash
		parts := strings.SplitN(string(line), ":", 7)
		if len(parts) < 7 || parts[0] == "" || parts[0][0] == '+' || parts[0][0] == '-' {
			return nil
		}

		uid, err := strconv.ParseUint(parts[2], 10, 32)
		if err != nil {
			return err
		}

		gid, err := strconv.ParseUint(parts[3], 10, 32)
		if err != nil {
			return err
		}

		users = append(users, &User{
			UID:     uint32(uid),
			GID:     uint32(gid),
			Login:   parts[0],
			HomeDir: parts[5],
			Shell:   parts[6],
			Gecos:   parts[4],
		})
		return nil
	})

	if err != nil {
		return nil, fmt.Errorf("parse passwd failed: %w", err)
	}

	return users, nil
}
