package passwd

import (
	"io"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

type readCloser struct {
	r io.Reader
}

func (r *readCloser) Read(p []byte) (n int, err error) {
	return r.r.Read(p)
}

func (r *readCloser) Close() error {
	return nil
}

func TestParsePasswd(t *testing.T) {
	r := &readCloser{r: strings.NewReader(`######## HERE ARE AUTHORIZED USERS FOR warwish-cauth-xenial.myt.yp-c.yandex.net ########
######## SERVER ADMINS FOR HOST warwish-cauth-xenial.myt.yp-c.yandex.net ########
warwish:*:53523:239396:Anton Suvorov:/home/warwish:/bin/bash
zeebdo:*:228397:239419:Mariia Matveenko:/home/zeebdo:/bin/bash
######## MD5:c4427565f40b36c84d5acfc0c114a506:####### REAL:vla1-0984-1.joayfyimq2c7xt3h.vla.yp-c.yandex.net:######`)}
	expected := []*User{
		{
			UID:     53523,
			GID:     239396,
			Login:   "warwish",
			HomeDir: "/home/warwish",
			Shell:   "/bin/bash",
			Gecos:   "Anton Suvorov",
		},
		{
			UID:     228397,
			GID:     239419,
			Login:   "zeebdo",
			HomeDir: "/home/zeebdo",
			Shell:   "/bin/bash",
			Gecos:   "Mariia Matveenko",
		},
	}
	users, err := ParsePasswd(r)
	assert.NoError(t, err)
	assert.Equal(t, expected, users)
}
