package passwd

import (
	"bufio"
	"bytes"
	"io"
)

func IterateLines(r io.Reader, fn func(line []byte) error) error {
	bs := bufio.NewScanner(r)
	// use large enough buffer when parsing groups as some groups could be huge
	// dpt_yandex and other similar groups
	buf := make([]byte, 4096)
	bs.Buffer(buf, 8*1024*1024)
	for bs.Scan() {
		line := bs.Bytes()
		// There's no spec for /etc/passwd or /etc/group, but we try to follow
		// the same rules as the glibc parser, which allows comments and blank
		// space at the beginning of a line.
		line = bytes.TrimSpace(line)
		if len(line) == 0 || line[0] == '#' {
			continue
		}

		if err := fn(line); err != nil {
			return err
		}
	}

	return bs.Err()
}
