package passwd

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestIterateLines(t *testing.T) {
	r := strings.NewReader("line1\nline2\n")
	var lines [][]byte
	expectedLines := [][]byte{[]byte("line1"), []byte("line2")}
	err := IterateLines(r, func(line []byte) error {
		lines = append(lines, line)
		return nil
	})
	assert.NoError(t, err)
	assert.Equal(t, expectedLines, lines)
}
