package storage

import (
	"fmt"
	"io"

	"a.yandex-team.ru/infra/cauth/agent/linux/yandex-cauth-userd/internal/passwd"
)

func generateAdminSudoers(serverAdmins io.ReadCloser, adminSudoers io.Writer) error {
	admins, err := passwd.ParsePasswd(serverAdmins)
	if err != nil {
		return err
	}
	for _, a := range admins {
		if _, err := fmt.Fprintf(adminSudoers, "%s ALL=(ALL) NOPASSWD: ALL\n", a.Login); err != nil {
			return err
		}
	}
	return nil
}
