package storage

import (
	"bytes"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestGenerateAdminSudoers(t *testing.T) {
	r := &readCloser{r: strings.NewReader("warwish:*:53523:239396:warwish:/home/warwish:/bin/bash\nzeebdo:*:228397:239419:zeebdo:/home/zeebdo:/bin/bash")}
	w := bytes.NewBuffer([]byte{})
	err := generateAdminSudoers(r, w)
	assert.NoError(t, err)
	assert.Equal(t, []byte("warwish ALL=(ALL) NOPASSWD: ALL\nzeebdo ALL=(ALL) NOPASSWD: ALL\n"), w.Bytes())
}
