package utils

import (
	"fmt"
	"io"

	"a.yandex-team.ru/infra/cauth/agent/linux/yandex-cauth-userd/internal/passwd"
)

func ParseKeys(r io.ReadCloser) ([]string, error) {
	var keys []string
	defer r.Close()
	err := passwd.IterateLines(r, func(line []byte) error {
		keys = append(keys, string(line))
		return nil
	})
	if err != nil {
		return nil, fmt.Errorf("faile to parse keys: %w", err)
	}
	return keys, nil
}
