package utils

import (
	"io"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

type readCloser struct {
	r io.Reader
}

func (r *readCloser) Read(p []byte) (n int, err error) {
	return r.r.Read(p)
}

func (r *readCloser) Close() error {
	return nil
}

func TestParseKeys(t *testing.T) {
	r := &readCloser{r: strings.NewReader(`mockmock mockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmock mock
mock mockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmock mockmock`)}
	expected := []string{
		"mockmock mockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmock mock",
		"mock mockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmockmock mockmock",
	}
	keys, err := ParseKeys(r)
	assert.NoError(t, err)
	assert.Equal(t, expected, keys)
}
