#!/usr/bin/env python

from collections import defaultdict
from itertools import chain
import requests
import shutil


session = requests.Session()

def get_admins():
    with open('admins', 'r') as admins:
        return [admin.strip() for admin in admins.read().split('\n') if admin.strip()]


def get_user_keys(users):
    userkeys = defaultdict(list)
    for user in users:
        response = session.get('https://cauth.yandex.net:4443/userkeys/{}'.format(user))
        for line in response.text.split('\n'):
            if not line or line.startswith('#'):
                continue

            key = line.split(':', 1)[-1].strip()
            userkeys[user].append(key)
    return userkeys


def mk_user_authorized_keys(userkeys):
    userkeys = userkeys or {}
    for user in userkeys:
        shutil.os.makedirs('src/home/{}/.ssh/'.format(user))
        with open('src/home/{}/.ssh/authorized_keys'.format(user), 'w') as output:
            output.write('\n'.join(userkeys[user]) + '\n')


def mk_root_authorized_keys(userkeys):
    userkeys = userkeys or {}
    all_keys = chain(*userkeys.values())

    shutil.os.makedirs('src/usr/lib/yandex/cauth-admin-keys/')
    with open('src/usr/lib/yandex/cauth-admin-keys/root.authorized_keys', 'w') as output:
        output.write('\n'.join(all_keys) + '\n')


def mk_authorized_keys():
    admins = get_admins()
    userkeys = get_user_keys(admins)

    shutil.rmtree('src/')
    mk_user_authorized_keys(userkeys)
    mk_root_authorized_keys(userkeys)


if __name__ == "__main__":
    mk_authorized_keys()
