# Источники данных для CAuth

CAuth периодически получает данные о группах, "хостах" и их ответственных из следующих источников:
1. [Wall-E](https://wall-e.yandex-team.ru/)
2. Bot
3. Conductor
4. GenCfg CMS
5. YP-export-service (QYP VMs)
Дополнительно, CAuth отгружает дерево "ресурсов" (= групп и хостов) и получает апдейты ролей на эти ресурсы из IDM.

Понятие "хосты" здесь и дальше используется в широком смысле, т.е. это может быть любой объект (железный сервер, контейнер или иное), который есть в связанных системах и имеющий PTR и A/AAAA DNS-запись. 

## Фильтрация ответственных по источникам (flow_type)
Сейчас CAuth получает информацию об ответственных за хосты из разных источников. При этом про один и тот же хост может знать несколько источников одновременно. Поэтому CAuth берет всех людей из всех источников и объединяет их, если не заданы соответствующие настройки по фильтрации ответственных. 

В CAuth существует два механизма фильтрации доверенных источников информации об отствественных за хост:
- backend sources: 
   - в качестве "доверенного" источника для CAuth (пока) выступает только система Wall-E. В настройках проекта Wall-E есть блок CAuth, в котором можно задать `flow type = backend_sources` и выбрать список доверенных источников инфромации про ответственных за хосты для конкретной команды;
   - в случае, если хост находится в проекте Wall-E с данным методом фильтрации, значения из файла конфигурации локального агента игнорируются;
- classic или client sources:
   - на хосте с CAuth-агентом может быть создан файл с конфигурацией (`/etc/cauth/cauth.conf`), в котором задается список источников, которым доверяет данный хост. При обращении в backend CAuth, локальный клиент на хосте передает в параметрах запросах этот список доверенных источников, и backend CAuth возвращает только ответственных, соответствующих параметрам запроса;
   - это не самая надежная схема, поэтому рекомендовано использовать backend sources, если это для вас применимо.

### Список доступных источников:
Теперь рассмотрим доступные для выбора опции по фильтрации. Напомню, что доступен множественный выбор, поэтому CAuth будет объединять список ответственных со всех источников, удовлетворяющих настройках фильтрации. 

У каждого источника есть своя специфика, поэтому ниже дан ответ на вопрос "Кто получит права?" в случае выбора того или иного источника:
- Wall-E: пользователи (логины, ABC- или Staff-группы), имеющие роль owner, superuser или user (ssh, но без парольного sudo) в соответствующем проекте Wall-E;
- Bot: пользователи, которые состоят в ABC-сервисе, за которым закреплен хост, имеющие роль `services_management` или `Hardware resources manager`;
- Conductor: пользователи, являющие ответственными за проект Conductor, к которому принадлежит хост в этой системе;
- CMS (он же GenCfg CMS): пользователи, которые указанны в настройках GenCfg-группы;
- YP (YP-export-service): пользователи, указанные в настройках конкретной VM в [QYP](https://qyp.yandex-team.ru/);
- IDM: если выбран данный источник, права получат все пользователи, права которым выданы на **любой** ресурс из дерева CAuth в самом IDM;
- IdmCms (он же IDM - CMS): пользователи, права которым выданы только через IDM на любой ресурс (включая GenCfg-группы), но при этом не давая прав ответственным из самого GenCfg;
- IdmConductor (он же IDM - Conductor): пользователи, права которым выданы на любой ресурс из дерева CAuth в самом IDM (включая Conductor-группы),  но при этом не давая прав ответственным из самого Conductor;
- Ycloud: deprecated, поддерживается до полной миграци YC на oslogin;


{% note warning %}

Указывать как единственный доверенный источник IDM в бОльшей части случаев — некорректно.
Исключение нужно согласовывать с командой разработки CAuth через тикет в очереди [CAUTH](https://st.yandex-team.ru/createTicket?queue=CAUTH)

{% endnote %}
