#include "bench_grp.h"

const std::vector<const bench_group*> GROUPS = {
    new bench_group{109702, "svc_infracloudnetwork"},
    new bench_group{113148, "dpt_yandex_mnt_sa_runtime_mondev_6921"},
    new bench_group{125043, "svc_srertc"},
    new bench_group{125067, "svc_srertc_administration"},
    new bench_group{135397, "dpt_yandex_mnt_sa_runtime_mondev_dep72038"},
    new bench_group{143317, "svc_srertc_devops"},
    new bench_group{162942, "svc_hostmanager"},
    new bench_group{20001, "dpt_yandex"},
    new bench_group{22081, "dpt_yandex_search_tech_searchinfradev_cluster"},
    new bench_group{22669, "dpt_yandex_mnt_sa_runtime_mondev"},
    new bench_group{227703, "dpt_yandex_dep79124"},
    new bench_group{233371, "dpt_yandex_infra_data_dep72813"},
    new bench_group{
        23892,
        "svc_admintools",
    },
    new bench_group{
        239396,
        "dpt_yandex_mnt_sa_runtime_mondev_dep72038_dep95294",
    },
    new bench_group{239419, "dpt_yandex_mnt_sa_runtime_mondev_dep72038_dep38906"},
    new bench_group{24460, "svc_cauth"},
    new bench_group{50971, "svc_cauth_development"},
    new bench_group{53274, "svc_wall-e"},
    new bench_group{53280, "svc_sr"},
    new bench_group{53358, "wiki_dist-dmove"},
    new bench_group{58760, "svc_dist"},
    new bench_group{58766, "svc_dist_administration"},
    new bench_group{59304, "dpt_yandex_infra_data"},
    new bench_group{62369, "svc_meta_search_administration"},
    new bench_group{70156, "svc_razrabotkayadralinux"},
    new bench_group{70160, "svc_porto"},
    new bench_group{85189, "svc_netmon"},
    new bench_group{85250, "svc_netmon_administration"},
    new bench_group{87443, "dpt_yandex_mnt_sa_runtime_mondev_0023"},
    new bench_group{93618, "dpt_yandex_exp_9053"},
};

bench_result* bench_getgrnam(const std::string& name) {
    auto start = std::chrono::high_resolution_clock::now();
    auto gr = getgrnam(name.c_str());
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (gr) {
        invalid = name != gr->gr_name;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, gr == nullptr, invalid};
}

bench_result* bench_getgrnam_r(const std::string& name) {
    auto start = std::chrono::high_resolution_clock::now();
    group gr = {};
    group* rv;
    const auto buf_sz = 512 * 1024;
    char buf[buf_sz];
    int failed = getgrnam_r(name.c_str(), &gr, buf, buf_sz, &rv);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (!failed) {
        invalid = name != gr.gr_name;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, bool(failed), invalid};
}

bench_result* bench_getgrgid(gid_t gid) {
    auto start = std::chrono::high_resolution_clock::now();
    auto gr = getgrgid(gid);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (gr) {
        invalid = gid != gr->gr_gid;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, gr == nullptr, invalid};
}

bench_result* bench_getgrgid_r(gid_t gid) {
    auto start = std::chrono::high_resolution_clock::now();
    group gr = {};
    group* rv;
    const auto buf_sz = 512 * 1024;
    char buf[buf_sz];
    int failed = getgrgid_r(gid, &gr, buf, buf_sz, &rv);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (!failed) {
        invalid = gid != gr.gr_gid;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, bool(failed), invalid};
}

GrNameBenchGen::GrNameBenchGen(const std::vector<const bench_group*>& groups) {
    this->groups.reserve(groups.size());
    for (const auto& g : groups) {
        this->groups.push_back(g);
    }
    this->len = groups.size();
    this->i = 0;
}

std::string GrNameBenchGen::next() {
    auto g = groups[i % len];
    i++;
    return g->name;
}

GidBenchGen::GidBenchGen(const std::vector<const bench_group*>& groups) {
    this->groups.reserve(groups.size());
    for (const auto& g : groups) {
        this->groups.push_back(g);
    }
    this->len = groups.size();
    this->i = 0;
}

gid_t GidBenchGen::next() {
    auto g = groups[i % len];
    i++;
    return g->gid;
}
