#pragma once

#include <grp.h>
#include <string>
#include <map>
#include <vector>
#include <utility>
#include "bench_common.h"
#include <unistd.h>

struct bench_group {
    gid_t gid;
    std::string name;
};

extern const std::vector<const bench_group*> GROUPS;

bench_result* bench_getgrnam(const std::string& name);
bench_result* bench_getgrnam_r(const std::string& name);
bench_result* bench_getgrgid(gid_t gid);
bench_result* bench_getgrgid_r(gid_t gid);

class GrNameBenchGen: public BenchGen<std::string> {
    size_t i;
    size_t len;
    std::vector<const bench_group*> groups;

public:
    explicit GrNameBenchGen(const std::vector<const bench_group*>& groups);

    std::string next() override;
};

class GidBenchGen: public BenchGen<gid_t> {
    size_t i;
    size_t len;
    std::vector<const bench_group*> groups;

public:
    explicit GidBenchGen(const std::vector<const bench_group*>& groups);

    gid_t next() override;
};
