#include "bench_pwd.h"

const std::map<int, std::string> USERS = {
    {
        53523,
        "warwish",
    },
    {
        228397,
        "zeebdo",
    },
    {
        39794,
        "max7255",
    },
    {
        58628,
        "zeil",
    },
    {
        91134,
        "wwfq",
    },
    {
        25033,
        "nekto0n",
    },
    {
        40630,
        "frolstas",
    },
    {
        98666,
        "vaspahomov",
    },
};

bench_result* bench_getpwnam(const std::string& login) {
    auto start = std::chrono::high_resolution_clock::now();
    auto pw = getpwnam(login.c_str());
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (pw) {
        invalid = login != pw->pw_name;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, pw == nullptr, invalid};
}

bench_result* bench_getpwnam_r(const std::string& login) {
    auto start = std::chrono::high_resolution_clock::now();
    passwd result = {};
    passwd* rv;
    char buf[4096];
    int failed = getpwnam_r(login.c_str(), &result, buf, 4096, &rv);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (!failed) {
        invalid = login != result.pw_name;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, bool(failed), invalid};
}

bench_result* bench_getpwuid(uid_t uid) {
    auto start = std::chrono::high_resolution_clock::now();
    auto pw = getpwuid(uid);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (pw) {
        invalid = uid != pw->pw_uid;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, pw == nullptr, invalid};
}

bench_result* bench_getpwuid_r(uid_t uid) {
    auto start = std::chrono::high_resolution_clock::now();
    passwd result = {};
    passwd* rv;
    char buf[4096];
    int failed = getpwuid_r(uid, &result, buf, 4096, &rv);
    auto end = std::chrono::high_resolution_clock::now();
    bool invalid = true;
    if (!failed) {
        invalid = uid != result.pw_uid;
    }
    std::chrono::nanoseconds diff = end - start;
    return new bench_result{diff.count() / 1000, bool(failed), invalid};
}

std::ostream& operator<<(std::ostream& s, passwd* p) {
    s << "passwd{"
      << "uid: " << p->pw_uid << ", "
      << "gid: " << p->pw_gid << ", "
      << "gecos: " << p->pw_gecos << ", "
      << "}";
    return s;
}

LoginBenchGen::LoginBenchGen(const std::map<int, std::string>& users)
    : usersvec(users.begin(), users.end())
{
    this->i = 0;
    this->len = users.size();
};

std::string LoginBenchGen::next() {
    auto n = this->i % this->len;
    auto rv = this->usersvec[n];
    this->i++;
    return rv.second;
}

UidBenchGen::UidBenchGen(const std::map<int, std::string>& users)
    : usersvec(users.begin(), users.end())
{
    this->i = 0;
    this->len = users.size();
};

uid_t UidBenchGen::next() {
    auto n = this->i % this->len;
    auto rv = this->usersvec[n];
    this->i++;
    return rv.first;
}
