#pragma once

#include <chrono>
#include <string>
#include <pwd.h>
#include <iostream>
#include <utility>
#include <vector>
#include <map>
#include "bench_common.h"
#include "channel.h"
#include "histogram.h"

extern const std::map<int, std::string> USERS;

bench_result* bench_getpwnam(const std::string& login);

bench_result* bench_getpwuid(uid_t uid);

bench_result* bench_getpwuid_r(uid_t uid);

bench_result* bench_getpwnam_r(const std::string& login);

class LoginBenchGen: public BenchGen<std::string> {
    size_t i;
    size_t len;
    std::vector<std::pair<int, std::string>> usersvec;

public:
    explicit LoginBenchGen(const std::map<int, std::string>& users);

    std::string next() override;
};

class UidBenchGen: public BenchGen<uid_t> {
    size_t i;
    size_t len;
    std::vector<std::pair<int, std::string>> usersvec;

public:
    explicit UidBenchGen(const std::map<int, std::string>& users);

    uid_t next() override;
};
