#pragma once

#include <mutex>
#include <deque>
#include <condition_variable>

template <class T>
class Channel {
    std::mutex data_mtx;
    std::deque<T> data;
    bool closed;
    bool ready;

public:
    Channel() {
        closed = false;
        ready = false;
    }

    bool opened() {
        return !closed;
    }

    void close() {
        closed = true;
    }

    void put(T val) {
        if (!closed) {
            data_mtx.lock();
            data.push_back(val);
            ready = true;
            data_mtx.unlock();
        }
    }

    T get() {
        data_mtx.lock();
        auto rv = data.front();
        data.pop_front();
        ready = !data.empty();
        data_mtx.unlock();
        return rv;
    }
    std::deque<T>& get_all() {
        return data;
    }
    bool has_data() {
        return ready;
    }
};
