#include "histogram.h"

std::ostream& operator<<(std::ostream& s, const Histogram<unsigned long>& h) {
    s << "Histogram<buckets: " << h.buckets.size() << ", max_bucket: " << *h.buckets.rbegin() << "us>" << std::endl;
    for (unsigned int i = 0; i < h.buckets.size(); i++) {
        if (h.counts[i]) {
            s << std::setw(8) << h.buckets[i] << "us: " << std::setw(8) << h.counts[i] << std::endl;
        }
    }
    return s;
}
