#pragma once

#include <vector>
#include <iostream>
#include <iomanip>

template <typename T>
class Histogram {
    std::vector<T> buckets;
    std::vector<size_t> counts;

public:
    explicit Histogram(const std::vector<T>& buckets)
        : buckets(buckets)
        , counts(buckets.size())
    {
    }

    void put(T val) {
        unsigned int i;
        for (i = 0; i < buckets.size(); i++) {
            if (val < buckets[i]) {
                counts[i]++;
                break;
            }
        }
        if (i == buckets.size()) {
            counts[i - 1]++;
        }
    }

    friend std::ostream& operator<<(std::ostream& s, const Histogram<T>& h);
};
