#!/bin/bash

ldap_ch=0;
http_ch=0;
https_ch=0;
# balancer ping files
#ldap_check='/opt/monitoring/ldap/index.html';
#http_check='/opt/monitoring/http/index.html';
#https_check='/opt/monitoring/https/index.html';
flag=0;
ldap_f="ldap(ok)";
http_f="http(ok)";
https_f="https(ok)";
# number of users that must be get on curl http://fqdn/passwd
users_number=6500

# ldap_u_4=$(ldapwhoami -p 389 -x -h 127.0.0.1);
ldap_u_4=$(ldapwhoami -x -H ldap://127.0.0.1:389 2>/dev/null);
if [ "$ldap_u_4" = "anonymous" ]; then let ldap_ch++; fi

if [ $ldap_ch -lt 1 ];
then
	ldap_f="ldap(failed)";
	flag=2;
#	echo "fail" > $ldap_check;
#else
#	echo "ok" > $ldap_check;
fi

#if [ $ldap_ch -eq 2 ]; then echo '<?php echo "ok" ?>'>$ldap_f; else echo '<?php echo "fail" ?>'>$ldap_f; fi

host=$(hostname -f);

http_4=$(curl -4 -s http://$host:4444/passwd/ | wc -l);
if [ $http_4 -ge $users_number ]; then let http_ch++; fi

http_6=$(curl -6 -s http://$host:4444/passwd/ | wc -l);
if [ $http_6 -ge $users_number ]; then let http_ch++; fi

# update balancer checks
if [ $http_ch -lt 1 ];
then
	http_f="http(failed)";
	flag=2;
#	echo "fail" > $http_check;
#else
#	echo "ok" > $http_check;
fi

https_4=$( curl -sk --cacert /etc/ldap/certs/cafile.pem -4 https://$host:4443/passwd/ | wc -l );
if [ $https_4 -ge $users_number ]; then let https_ch++; fi

https_6=$( curl -sk --cacert /etc/ldap/certs/cafile.pem -6 https://$host:4443/passwd/ | wc -l );
if [ $https_6 -ge $users_number ]; then let https_ch++; fi

if [ $https_ch -lt 1 ];
then
	https_f="https(failed)";
	flag="2";
#	echo "fail" > $https_check;
#else
#	echo "ok" > $https_check;
fi

echo "$flag;$ldap_f,$http_f,$https_f";

