#!/bin/bash

check="haproxy";
pidfile="/run/haproxy.pid";
status=0
warn_workers=4
crit_workers=2
errbacks=""
desc="OK"
processes=0

socknum=$(ls /tmp/haproxy-worker[1-8] 2>/dev/null | wc -l)

if [ $socknum -lt 8 ]
then
    status=1
    desc="statistics sockets number lower then 8."
fi

# look up for sockets
if [ $socknum -lt 1 ]
then
    status=2
    desc="statistics sockets not found."
fi

# check pids and haproxy runnning
processes=$(ps ax | grep happroxy | grep -v grep | wc -l)
if [ -f $pidfile ]
then
    pidsnum=$(cat $pidfile | wc -l)
    if [ $pidsnum -lt 1 ]
    then
        status=2
        desc="process haproxy pids not found."
    fi
    pids=$(cat $pidfile)
    deadpids=0
    for pid in $pids
    do
        # check for the process with pid alive and count dead pids
        pidex=$(ps ax | grep $pid | grep -v grep | wc -l)
        if [ $pidex -lt 1 ]
        then
            let deadpids=$deadpids+1
        fi
    done
    # check running haproxy workers with known pid
    if [ $deadpids -gt 6 ]
    then
        status=2
        desc="too many dead pids for haproxy: $deadpids running processes: $processes"
    elif [ $deadpids -gt 0 ] && [ $deadpids -lt 6 ]
    then
        status=1
        desc="many dead pids for haproxy: $deadpids  running processes: $processes"
    fi
else
    status=2
    desc="pidfile not found, running haproxy processes: $processes"
fi

if [ $status -ne 2 ]
then
    sockets=$(ls /tmp/haproxy-worker*);
    for sock in $sockets
    do
        backends=$(echo 'show stat' | socat stdio unix-connect:$sock | grep BACKEND | awk -F ',' '{print $1}')
        errbacks=""
        for back in $backends
        do
            state=$(echo 'show stat' | socat stdio unix-connect:$sock | grep BACKEND | awk -F ',' '{print $1 " " $18}' | grep $back | cut -d " " -f 2)
            if [ "$state" == "DOWN" ]
            then
                status=2
                # check if failed backend exists in errback list and prevent duplicates
                errbacks=$errbacks" "$back":"$state
            fi
        done
        if [ $status -eq 2 ]
        then
            echo "2;$errbacks"
            exit 0
        fi

    done
fi

echo "$status;$desc"
