#!/bin/bash

checklog="/var/log/auth.log"
# monitoring log
log="/var/log/saslcheck/krb5_check.log"
err_search="k5support_verify_tgt"
# number of seconds to watch back the log file
interval=60
tail="/usr/bin/timetail -t syslog -n $interval "
# found errors limit for rising critical error (ldap_simple_bind() failed -1)
conn_err_limit=2

wrlog()
{
        echo `date -R`" saslauthd_check" "$1" >> $log
        if [ $? -ne 0 ]
        then
                return 1
        else
                return 0
        fi
}

saslauthcheck()
{
    err_found=`$tail $checklog | grep -i "$err_search" | wc -l`

        if [ $err_found -gt 0 ] && [ $err_found -lt $conn_err_limit ]
        then
                wrlog "Warning: Detected $err_found critical auth errors for last $interval seconds."
                echo 1
                return 0
        fi

    if [ $err_found -ge $conn_err_limit ]
    then
        wrlog "Critical: Detected $err_found critical auth errors for last $interval seconds."
        echo 2
        return 0
    fi
        echo 0
        return 0
}

saslcheck=$(saslauthcheck)

# define monrun message

ld_msg="2;Fail"

if [ $saslcheck -eq 0 ]
then
    ld_msg="0;OK"
elif [ $saslcheck -eq 1 ]
then
	ld_msg="1;Warning. krb5 detected critical auth errors, but it's number is lower than $conn_err_limit"
else
    ld_msg="2;Critical. krb5 detected critical auth errors more than $conn_err_limit"
fi

echo $ld_msg

exit 0
