#!/bin/sh

HAPROXY_SLB_RESPONSE_LUA_SCRIPT="/etc/haproxy/slb-response.lua"

if [ ! -f "${HAPROXY_SLB_RESPONSE_LUA_SCRIPT}" ];
then
	echo "2;File /etc/haproxy/slb-response.lua does not exist"
	exit 1
fi

retcode=$(grep -oP "(?<=set_status\().*(?=\))" "${HAPROXY_SLB_RESPONSE_LUA_SCRIPT}");

if [ "$retcode" = "401" ];
then
	echo "2;HAproxy returns 401 to SLB pings";
	exit 1
elif [ "$retcode" = "200" ];
then
	echo "0;HAproxy returns 200 to SLB pings";
	exit 1
else
	echo "2;HAproxy returns onknown code '${retcode}' to SLB pings";
	exit 1
fi
