#!/bin/bash

code="0"
msg="Ok"

warn="28"
crit="15"

statfile="/tmp/yandex-tools-cert-check.stat"
certs="/etc/cauth-ldap-certs/cauth.yandex.net.crt /etc/cauth-ldap-certs/cauth.yandex.net.pem /etc/cauth-ldap-certs/ca.crt"

now=$(date +%s)


if [[ -f $statfile ]]; then
    statmtime=$(stat --printf=%Y $statfile)
    # Проверяем не чаще раза в сутки
    if [[ $(($now - $statmtime)) -lt 86400 ]]; then
        cat $statfile
        exit 0
    fi
fi

echo "1;Check running" > $statfile

function setcode {
    if [[ $1 -gt $code ]]; then
        code="$1"
    fi
}

function addreason {
    if [[ $msg == "Ok" ]]; then
        msg="$1"
    else
        msg="$msg, $1"
    fi
}


for cert_file in $certs; do
sslinfo=$(openssl x509 -in $cert_file -noout -enddate -subject 2>/dev/null)
endstr=$(echo "$sslinfo" | egrep '^notAfter=' | sed 's/^notAfter=//')
enddate=$(date +%s -d "$endstr")

# Похоже на дату
if [[ $enddate =~ [0-9]{10} ]]; then
    setcode 0
else
    setcode 1
    addreason "$cert_file get unix date failed"
    continue
fi

diff=$(( ($enddate - $now)/86400 ))

if [[ $diff -gt $warn ]]; then
    setcode 0
    addreason "$cert_file ok"
elif [[ $diff -gt $crit ]]; then
    setcode 1
    addreason "$cert_file expires in $diff days"
else
    setcode 2
    addreason "$cert_file expires in $diff days"
fi

done

echo "$code;$msg"
echo "$code;$msg" > $statfile
