import psycopg2

from sqlalchemy import create_engine
from sqlalchemy.orm import scoped_session, sessionmaker

from django.conf import settings


def create_cauth_engine(dsn_pattern, params):
    return create_engine(
        'postgresql://',
        encoding=str('utf-8'),
        echo=getattr(settings, 'CAUTH_SQL_ENGINE_ECHO', False),
        creator=lambda: psycopg2.connect(
            dsn_pattern.format(**params)
        ),
        pool_recycle=900,  # 15m
    )


engine = create_cauth_engine(settings.PSYCOPG2_DSN_PATTERN, settings.DATABASES['default'])

session_factory = sessionmaker(bind=engine, expire_on_commit=False)
Session = scoped_session(session_factory)
