class CLIENT_SOURCE_REASON:
    FROM_CLIENT = 'from_client'
    FROM_SOURCE = 'from_source'
    FROM_RESPONSIBLE = 'from_responsible'

    @classmethod
    def choices(cls):
        return (
            cls.FROM_CLIENT,
            cls.FROM_SOURCE,
            cls.FROM_RESPONSIBLE,
        )


class ACTION_TYPE:
    ADD_TRUSTED_SOURCE = 'add_trusted_source'
    REMOVE_TRUSTED_SOURCE = 'remove_trusted_source'

    @classmethod
    def choices(cls):
        return (
            cls.ADD_TRUSTED_SOURCE,
            cls.REMOVE_TRUSTED_SOURCE,
        )


class USER_GROUP_TYPE:
    DPT = 'dpt'
    WIKI = 'wiki'
    SVC = 'svc'
    SVC_ROLE = 'svcrole'
    VIRTUAL = 'virtual'

    @classmethod
    def choises(cls):
        return (
            cls.DPT,
            cls.WIKI,
            cls.SVC,
            cls.SVC_ROLE,
            cls.VIRTUAL,
        )


class SERVER_TYPE:
    SERVER = 'server'
    DEV_SERVER = 'dev-server'

    DEFAULT = SERVER

    @classmethod
    def choices(cls):
        return (
            cls.SERVER,
            cls.DEV_SERVER,
        )

    @classmethod
    def tuple_choices(cls):
        return (
            (cls.SERVER, 'Server'),
            (cls.DEV_SERVER, 'Development Server'),
        )


class IDM_STATUS:
    ACTUAL = 'actual'
    DIRTY = 'dirty'

    @classmethod
    def choices(cls):
        return (
            cls.ACTUAL,
            cls.DIRTY,
        )

    @classmethod
    def tuple_choices(cls):
        return (
            (cls.ACTUAL, 'Actual'),
            (cls.DIRTY, 'Dirty'),
        )


class ACCESS_TYPE:
    SSH = 'ssh'
    SUDO = 'sudo'
    EINE = 'eine'

    @classmethod
    def choices(cls):
        return (
            cls.SSH,
            cls.SUDO,
            cls.EINE,
        )


class FLOW_TYPE:
    CLASSIC = 'classic'
    BACKEND_SOURCES = 'backend_sources'

    @classmethod
    def choices(cls):
        return (
            cls.CLASSIC,
            cls.BACKEND_SOURCES
        )

    @classmethod
    def tuple_choices(cls):
        return (
            (cls.CLASSIC, 'Classic'),
            (cls.BACKEND_SOURCES, 'Backend-sources'),
        )


class KEY_SOURCE:
    STAFF = 'staff'
    SECURE = 'secure'
    INSECURE = 'insecure'

    @classmethod
    def choices(cls):
        return (
            cls.STAFF,
            cls.SECURE,
            cls.INSECURE,
        )


class KEYS_INFO_ATTR:
    KEY_SOURCES = 'key_sources'
    SECURE_CA_LIST_URL = 'secure_ca_list_url'
    INSECURE_CA_LIST_URL = 'insecure_ca_list_url'
    KRL_URL = 'krl_url'
    SUDO_CA_LIST_URL = 'sudo_ca_list_url'

    DEFAULTS = {
        KEY_SOURCES: KEY_SOURCE.STAFF,
        SECURE_CA_LIST_URL: 'https://cauth.yandex.net:4443/keylists/main/secure',
        INSECURE_CA_LIST_URL: 'https://cauth.yandex.net:4443/keylists/main/insecure',
        KRL_URL: 'https://cauth.yandex.net:4443/keylists/main/all.zst',
        SUDO_CA_LIST_URL: 'https://cauth.yandex.net:4443/keylists/main/sudo',
    }
