from .alchemy import Session


class SqlAlchemySessionMiddleware:
    @staticmethod
    def process_response(request, response):
        dirty = [x for x in Session.dirty if Session.is_modified(x)]
        dirty += Session.new
        dirty += Session.deleted
        if dirty:
            raise RuntimeError(
                "Session has not been propery commited/rolled back. "
                "Pending objects: %s" % dirty
            )
        Session.remove()
        return response

    @staticmethod
    def process_exception(request, exception):
        Session.remove()
