CREATE TABLE allowed_q_requesters (
	id INTEGER NOT NULL AUTO_INCREMENT,
	description VARCHAR(200) NOT NULL,
	fqdn VARCHAR(100),
	macro VARCHAR(100),
	cidr VARCHAR(48),
	cidr_family ENUM('4','6'),
	cidr_first BIGINT,
	cidr_last BIGINT,
	PRIMARY KEY (id)
);

CREATE INDEX ix_allowed_q_requesters_fqdn ON allowed_q_requesters (fqdn);
CREATE INDEX ix_allowed_q_requesters_macro ON allowed_q_requesters (macro);
CREATE INDEX search ON allowed_q_requesters (cidr_family, cidr_first, cidr_last);
