CREATE TABLE `new_sources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(16) NOT NULL,
  `is_default` BOOL NOT NULL DEFAULT 0,
  `last_update` DATETIME,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  CHECK (is_default IN (0, 1))
) ENGINE=InnoDB;

INSERT INTO `new_sources` (`id`, `name`, `is_default`)
  VALUES (1, 'default', 1), (2, 'initial', 0);

CREATE TABLE `new_server_sources` (
  `server_id` int(11) NOT NULL,
  `source_id` int(11) NOT NULL,
  PRIMARY KEY (`server_id`,`source_id`),
  KEY `ix_new_server_sources_source_id` (`source_id`),
  CONSTRAINT `new_server_sources_ibfk_1` FOREIGN KEY (`server_id`)
    REFERENCES `new_servers` (`id`) ON DELETE CASCADE,
  CONSTRAINT `new_server_sources_ibfk_2` FOREIGN KEY (`source_id`)
    REFERENCES `new_sources` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

CREATE TABLE new_updated_servers (
	fqdn VARCHAR(128) NOT NULL,
	PRIMARY KEY (fqdn)
)ENGINE=InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

CREATE TABLE new_updated_server_groups (
    name VARCHAR(128) NOT NULL,
    PRIMARY KEY (name)
)ENGINE=InnoDB CHARSET=utf8 COLLATE utf8_general_ci;

ALTER TABLE `new_server_groups` ADD COLUMN `source_id` int(11),
  ADD FOREIGN KEY `new_server_groups_ibfk_1` (`source_id`)
    REFERENCES `new_sources` (`id`) ON DELETE SET NULL;
ALTER TABLE `new_server_responsibles` ADD COLUMN `source_id` int(11) NOT NULL DEFAULT 2,
  ADD FOREIGN KEY `new_server_responsibles_ibfk3` (`source_id`)
    REFERENCES `new_sources` (`id`) ON DELETE CASCADE,
  DROP PRIMARY KEY,
  ADD PRIMARY KEY (`server_id`, `uid`, `source_id`);

ALTER TABLE `new_access` DROP FOREIGN KEY `new_access_ibfk_5`;
ALTER TABLE `new_access` ADD CONSTRAINT `new_access_ibfk_5` FOREIGN KEY (`sudo_role_id`) REFERENCES  `new_roles` (`id`) ON DELETE SET NULL;
