create table `actions` (
  `id` integer not null auto_increment,
  `type` enum('add_trusted_source', 'remove_trusted_source') not null,
  `server_id` integer,
  `source_id` integer,
  `created` datetime not null,

  primary key (`id`),

  foreign key(`server_id`) references `new_servers` (`id`) on delete restrict,
  foreign key(`source_id`) references `new_sources` (`id`) on delete restrict
) engine=InnoDB;

alter table `new_servers_m2m_client_sources` rename `new_servers_m2m_trusted_sources`;

alter table `new_servers_m2m_trusted_sources` drop foreign key `new_servers_m2m_trusted_sources_ibfk_1`;
alter table `new_servers_m2m_trusted_sources` drop foreign key `new_servers_m2m_trusted_sources_ibfk_2`;

alter table `new_servers_m2m_trusted_sources` drop primary key;

alter table `new_servers_m2m_trusted_sources` add column `id` integer primary key auto_increment first;

alter table `new_servers_m2m_trusted_sources` add constraint `server_source_uc` unique index (`server_id`, `source_id`);

alter table `new_servers_m2m_trusted_sources` add constraint `new_servers_m2m_trusted_sources_ibfk_1` foreign key (`server_id`) references `new_servers`(`id`);
alter table `new_servers_m2m_trusted_sources` add constraint `new_servers_m2m_trusted_sources_ibfk_2` foreign key (`source_id`) references `new_sources`(`id`);
