CREATE TYPE idm_status as enum ('actual', 'dirty');

ALTER TABLE new_server_groups
    ALTER COLUMN idm_status DROP DEFAULT,
    ALTER COLUMN idm_status TYPE idm_status USING idm_status::idm_status,
    ALTER COLUMN idm_status SET DEFAULT 'actual';

ALTER TABLE new_server_groups
    DROP CONSTRAINT new_server_groups_idm_status_check;


ALTER TABLE new_servers
    ALTER COLUMN idm_status DROP DEFAULT,
    ALTER COLUMN idm_status TYPE idm_status USING idm_status::idm_status,
    ALTER COLUMN idm_status SET DEFAULT 'actual';

ALTER TABLE new_servers
    DROP CONSTRAINT new_servers_idm_status_check;


CREATE TYPE server_type as enum ('server', 'dev-server');

ALTER TABLE new_servers
    ALTER COLUMN type DROP DEFAULT,
    ALTER COLUMN type TYPE server_type USING type::server_type,
    ALTER COLUMN type SET DEFAULT 'server';

ALTER TABLE new_servers
    DROP CONSTRAINT new_servers_type_check;


CREATE TYPE user_group_type as enum ('dpt', 'wiki', 'svc', 'virtual', 'svcrole');

ALTER TABLE new_groups
    ALTER COLUMN type TYPE user_group_type USING type::user_group_type;

ALTER TABLE new_groups
    DROP CONSTRAINT new_groups_type_check;


CREATE TYPE client_source_reason as enum ('from_client', 'from_responsible');

ALTER TABLE new_servers_m2m_trusted_sources
    ALTER COLUMN reason TYPE client_source_reason USING reason::client_source_reason;

ALTER TABLE new_servers_m2m_trusted_sources
    DROP CONSTRAINT new_servers_m2m_trusted_sources_reason_check;


CREATE TYPE action_type as enum ('add_trusted_source', 'remove_trusted_source');

ALTER TABLE actions
    ALTER COLUMN type TYPE action_type USING type::action_type;

ALTER TABLE actions
    DROP CONSTRAINT actions_type_check;


CREATE TYPE access_type as enum ('ssh', 'sudo', 'eine');

ALTER TABLE new_access
    ALTER COLUMN type TYPE access_type USING type::access_type;

ALTER TABLE new_access
    DROP CONSTRAINT new_access_type_check;


CREATE TYPE dns_status as enum ('ok', 'some_ptr_missing', 'cname', 'has_no_ptrs', 'cant_resolve');

ALTER TABLE server_flags DROP CONSTRAINT IF EXISTS server_flags_dns_status_check;

UPDATE server_flags SET dns_status = LOWER(dns_status);

ALTER TABLE server_flags
    ALTER COLUMN dns_status TYPE dns_status USING dns_status::dns_status;

ALTER TABLE server_flags
    DROP CONSTRAINT server_flags_server_id_fkey;


ALTER TABLE new_users_m2m_groups
    DROP CONSTRAINT new_users_m2m_groups_gid_fkey,
    ADD CONSTRAINT new_users_m2m_groups_gid_fkey FOREIGN KEY (gid) REFERENCES new_groups(gid) ON DELETE CASCADE;

ALTER TABLE new_users_m2m_groups
    DROP CONSTRAINT new_users_m2m_groups_uid_fkey,
    ADD CONSTRAINT new_users_m2m_groups_uid_fkey FOREIGN KEY (uid) REFERENCES new_users(uid) ON DELETE CASCADE;


ALTER TABLE new_servers_m2m_groups
    DROP CONSTRAINT new_servers_m2m_groups_group_id_fkey,
    ADD CONSTRAINT new_servers_m2m_groups_group_id_fkey FOREIGN KEY (group_id) REFERENCES new_server_groups(id) ON DELETE CASCADE;

ALTER TABLE new_servers_m2m_groups
    DROP CONSTRAINT new_servers_m2m_groups_server_id_fkey,
    ADD CONSTRAINT new_servers_m2m_groups_server_id_fkey FOREIGN KEY (server_id) REFERENCES new_servers(id) ON DELETE CASCADE;


ALTER TABLE new_server_group_responsibles
    DROP CONSTRAINT new_server_group_responsibles_uid_fkey,
    ADD CONSTRAINT new_server_group_responsibles_uid_fkey FOREIGN KEY (uid) REFERENCES new_users(uid) ON DELETE CASCADE;

ALTER TABLE new_server_group_responsibles
    DROP CONSTRAINT new_server_group_responsibles_group_id_fkey,
    ADD CONSTRAINT new_server_group_responsibles_group_id_fkey FOREIGN KEY (group_id) REFERENCES new_server_groups(id) ON DELETE CASCADE;


ALTER TABLE new_server_sources
    DROP CONSTRAINT new_server_sources_source_id_fkey,
    ADD CONSTRAINT new_server_sources_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE CASCADE;

ALTER TABLE new_server_sources
    DROP CONSTRAINT new_server_sources_server_id_fkey,
    ADD CONSTRAINT new_server_sources_server_id_fkey FOREIGN KEY (server_id) REFERENCES new_servers(id) ON DELETE CASCADE;


ALTER TABLE new_server_responsibles
    DROP CONSTRAINT new_server_responsibles_server_id_fkey,
    ADD CONSTRAINT new_server_responsibles_server_id_fkey FOREIGN KEY (server_id) REFERENCES new_servers(id) ON DELETE CASCADE;

ALTER TABLE new_server_responsibles
    DROP CONSTRAINT new_server_responsibles_source_id_fkey,
    ADD CONSTRAINT new_server_responsibles_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE CASCADE;

ALTER TABLE new_server_responsibles
    DROP CONSTRAINT new_server_responsibles_uid_fkey,
    ADD CONSTRAINT new_server_responsibles_uid_fkey FOREIGN KEY (uid) REFERENCES new_users(uid) ON DELETE CASCADE;


ALTER TABLE new_servers_m2m_trusted_sources
    DROP CONSTRAINT new_servers_m2m_trusted_sources_server_id_fkey,
    ADD CONSTRAINT new_servers_m2m_trusted_sources_server_id_fkey FOREIGN KEY (server_id) REFERENCES new_servers(id) ON DELETE CASCADE;

ALTER TABLE new_servers_m2m_trusted_sources
    DROP CONSTRAINT new_servers_m2m_trusted_sources_source_id_fkey,
    ADD CONSTRAINT new_servers_m2m_trusted_sources_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE CASCADE;


ALTER TABLE actions
    DROP CONSTRAINT actions_server_id_fkey,
    ADD CONSTRAINT actions_server_id_fkey FOREIGN KEY (server_id) REFERENCES new_servers(id) ON DELETE CASCADE;

ALTER TABLE actions
    DROP CONSTRAINT actions_source_id_fkey,
    ADD CONSTRAINT actions_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE CASCADE;


ALTER TABLE new_pubkeys
    DROP CONSTRAINT new_pubkeys_uid_fkey,
    ADD CONSTRAINT new_pubkeys_uid_fkey FOREIGN KEY (uid) REFERENCES new_users(uid) ON DELETE CASCADE;


ALTER TABLE new_server_groups
    DROP CONSTRAINT new_server_groups_source_id_fkey,
    ADD CONSTRAINT new_server_groups_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE SET NULL;


ALTER TABLE new_access
    DROP CONSTRAINT new_access_dst_group_id_fkey,
    ADD CONSTRAINT new_access_dst_group_id_fkey FOREIGN KEY (dst_group_id) REFERENCES new_server_groups(id) ON DELETE SET NULL;

ALTER TABLE new_access
    DROP CONSTRAINT new_access_dst_server_id_fkey,
    ADD CONSTRAINT new_access_dst_server_id_fkey FOREIGN KEY (dst_server_id) REFERENCES new_servers(id) ON DELETE SET NULL;

ALTER TABLE new_access
    DROP CONSTRAINT new_access_src_group_id_fkey,
    ADD CONSTRAINT new_access_src_group_id_fkey FOREIGN KEY (src_group_id) REFERENCES new_groups(gid) ON DELETE SET NULL;

ALTER TABLE new_access
    DROP CONSTRAINT new_access_src_user_id_fkey,
    ADD CONSTRAINT new_access_src_user_id_fkey FOREIGN KEY (src_user_id) REFERENCES new_users(uid) ON DELETE SET NULL;

ALTER TABLE new_access
    DROP CONSTRAINT new_access_sudo_role_id_fkey,
    ADD CONSTRAINT new_access_sudo_role_id_fkey FOREIGN KEY (sudo_role_id) REFERENCES new_roles(id) ON DELETE SET NULL;
