CREATE TYPE flow_type as enum('classic', 'backend_sources');

ALTER TABLE new_servers
    ADD COLUMN flow flow_type,
    ADD COLUMN owner_id INTEGER,
    ADD CONSTRAINT new_servers_owner_id_fkey FOREIGN KEY (owner_id) REFERENCES new_sources(id) ON DELETE RESTRICT;

ALTER TABLE new_sources
    ADD COLUMN is_modern BOOLEAN NOT NULL DEFAULT FALSE;

-- use by chunks in prod, please
UPDATE new_servers SET flow = 'classic' WHERE flow IS NULL;

ALTER TABLE new_servers
   ALTER COLUMN flow SET DEFAULT 'classic',
   ALTER COLUMN flow SET NOT NULL;
