-- ServerGroup

ALTER TABLE new_server_groups
    ADD COLUMN flow flow_type;

-- use by chunks in prod, please
UPDATE new_server_groups SET flow = 'classic' WHERE flow IS NULL;

ALTER TABLE new_server_groups
   ALTER COLUMN flow SET DEFAULT 'classic',
   ALTER COLUMN flow SET NOT NULL;


-- ServerGroupTrustedSources

CREATE TABLE new_servergroups_m2m_trusted_sources (
    id SERIAL PRIMARY KEY,
    servergroup_id integer,
    source_id integer,
    created timestamp without time zone NOT NULL,
    reason client_source_reason NOT NULL
);

ALTER TABLE ONLY new_servergroups_m2m_trusted_sources
    ADD CONSTRAINT servergroup_source_uc UNIQUE (servergroup_id, source_id);

ALTER TABLE ONLY new_servergroups_m2m_trusted_sources
    ADD CONSTRAINT new_servergroups_m2m_trusted_sources_servergroup_id_fkey FOREIGN KEY (servergroup_id) REFERENCES new_server_groups(id) ON DELETE CASCADE;

ALTER TABLE ONLY new_servergroups_m2m_trusted_sources
    ADD CONSTRAINT new_servergroups_m2m_trusted_sources_source_id_fkey FOREIGN KEY (source_id) REFERENCES new_sources(id) ON DELETE CASCADE;


-- Action

ALTER TABLE actions
    ADD COLUMN servergroup_id integer;

ALTER TABLE ONLY actions
    ADD CONSTRAINT actions_servergroup_id_fkey FOREIGN KEY (servergroup_id) REFERENCES new_server_groups(id) ON DELETE CASCADE;


-- Can be processed after a while
-- Server
ALTER TABLE new_servers
    DROP COLUMN flow;
