DELETE
FROM django_celery_beat_periodictask;

DELETE
FROM django_celery_beat_intervalschedule;
INSERT INTO django_celery_beat_intervalschedule (id, every, period) (SELECT id, every, period
                                                                     from djcelery_intervalschedule
                                                                     ORDER BY id);
SELECT setval('django_celery_beat_intervalschedule_id_seq', max(id))
FROM django_celery_beat_intervalschedule;

DELETE
FROM django_celery_beat_crontabschedule;
ALTER SEQUENCE django_celery_beat_crontabschedule_id_seq RESTART;
INSERT INTO django_celery_beat_crontabschedule (id, minute, hour, day_of_week, day_of_month,
                                                month_of_year,
                                                timezone) (SELECT id, minute, hour, day_of_week, day_of_month, month_of_year, 'Europe/Moscow'
                                                           from djcelery_crontabschedule
                                                           ORDER BY id);
SELECT setval('django_celery_beat_crontabschedule_id_seq', max(id))
FROM django_celery_beat_crontabschedule;

ALTER SEQUENCE django_celery_beat_periodictask_id_seq RESTART;
INSERT INTO django_celery_beat_periodictask (name, task, interval_id, crontab_id, args, kwargs,
                                             enabled, last_run_at, total_run_count,
                                             date_changed, description, one_off,
                                             headers) (SELECT REVERSE(SPLIT_PART(REVERSE(name), '.', 1)),
                                                              REPLACE(task, 'cauth_master.',
                                                                      'infra.cauth.server.master.'),
                                                              interval_id,
                                                              crontab_id,
                                                              args,
                                                              kwargs,
                                                              enabled,
                                                              last_run_at,
                                                              total_run_count,
                                                              date_changed,
                                                              description,
                                                              FALSE,
                                                              '{}'
                                                       from djcelery_periodictask
                                                       ORDER BY id);
