import os
import pwd
import grp
import psutil


def create_pgaas_profile(manager, config, profile_type):
    return {
        'ENGINE': 'django_pgaas.backend',
        'HOST': manager.host_string,
        'PORT': config.pg_port or 6432,
        'USER': config.pg_user or 'cauth',
        'PASSWORD': config.pg_password,
        'NAME': config.pg_name or 'cauth',
        'CONN_MAX_AGE': 2 * 60,  # 2 minutes
        'DISABLE_SERVER_SIDE_CURSORS': True,
        'OPTIONS': {
            'connect_timeout': 2,
            'sslmode': 'verify-full',
            'sslrootcert': '/usr/share/yandex-internal-root-ca/YandexInternalRootCA.crt',
            'target_session_attrs': profile_type
        },
    }


def source_process_env(name):
    pid = None
    for proc in psutil.process_iter():
        if name == proc.name():
            pid = proc.pid
            break

    if not pid:
        return

    env_file = '/proc/{}/environ'.format(pid)
    if os.path.isfile(env_file):
        with open(env_file, 'r') as runtime_env:
            envspecs = runtime_env.read().split('\000')
        for envspec in envspecs:
            if envspec:
                env, val = envspec.split('=', 1)
                os.environ[env] = val


def chown(path, user='www-data'):
    uid = pwd.getpwnam(user).pw_uid
    gid = grp.getgrnam(user).gr_gid

    if uid and gid:
        os.chown(path, uid, gid)
