from django import forms
from django.core.exceptions import ValidationError

from sqlalchemy.exc import InvalidRequestError


class AlchemyFallbackChoiceField(forms.ModelChoiceField):
    def __deepcopy__(self, memo):
        result = super(forms.ChoiceField, self).__deepcopy__(memo)
        # # Need to force a new ModelChoiceIterator to be created, bug #11183
        # if self.queryset is not None:
        #     result.queryset = self.queryset.all()
        return result

    def to_python(self, value):
        if value in self.empty_values:
            return None

        if isinstance(self.to_field_name, list):
            keys = self.to_field_name
        else:
            keys = [self.to_field_name]

        if isinstance(self.queryset, list):
            querysets = self.queryset
        else:
            querysets = [self.queryset]

        for key, queryset in zip(keys, querysets):
            try:
                key = key or 'id'
                return queryset().filter_by(**{key: value}).one()
            except InvalidRequestError:
                pass

        raise ValidationError(self.error_messages['invalid_choice'], code='invalid_choice')
