class RoleBase(object):
    fields = None
    level = None

    def __init__(self, src, parent=None):
        self.src = src
        self.parent = parent

    @property
    def key(self):
        raise NotImplementedError

    @property
    def path(self):
        levels = []

        current = self
        while current:
            levels.append(current.key)
            levels.append(current.level)
            current = current.parent

        return '/%s/' % '/'.join(reversed(levels))

    def render(self):
        result = {
            'path': self.path,
        }

        if self.fields:
            result['fields'] = self.fields

        result[self.src.key_name] = self.src.key

        return result


class DstRole(RoleBase):
    level = 'dst'

    def __init__(self, src, dst, *args, **kwargs):
        self.dst = dst
        super(DstRole, self).__init__(src, *args, **kwargs)

    @property
    def key(self):
        return self.dst.key


class SshRole(RoleBase):
    key = 'ssh'
    level = 'role'

    def __init__(self, src, rule, *args, **kwargs):
        self.rule = rule
        super(SshRole, self).__init__(src, *args, **kwargs)

    @property
    def fields(self):
        return {'root': bool(self.rule.ssh_is_admin)}


class SudoRole(RoleBase):
    key = 'sudo'
    level = 'role'

    def __init__(self, src, rule, *args, **kwargs):
        self.rule = rule
        super(SudoRole, self).__init__(src, *args, **kwargs)

    @property
    def fields(self):
        return {'role': self.rule.sudo_role.spec}


class EineRole(RoleBase):
    key = 'eine'
    level = 'role'

    def __init__(self, src, rule, *args, **kwargs):
        self.rule = rule
        super(EineRole, self).__init__(src, *args, **kwargs)

    @property
    def fields(self):
        return {}
