class SrcBase(object):
    slug = None

    @property
    def key(self):
        raise NotImplementedError

    def __hash__(self):
        return hash(self.key)

    def __eq__(self, other):
        if not isinstance(other, type(self)):
            return False

        return other.key == self.key

    def __repr__(self):
        return '<{}: {}>'.format(type(self).__name__, self.key)


class PersonSrc(SrcBase):
    slug = 'users'
    key_name = 'login'

    def __init__(self, login):
        self.login = login

    @property
    def key(self):
        return self.login


class GroupSrc(SrcBase):
    slug = 'groups'
    key_name = 'group'

    def __init__(self, staff_id):
        self.staff_id = staff_id

    @property
    def key(self):
        return int(self.staff_id)
