import json

from django.utils.functional import cached_property

from infra.cauth.server.master.api.tasks import update_server_sources
from infra.cauth.server.master.api.views.base import BaseView, RequestError


class ClientUpdateServerView(BaseView):
    REQUIRE_CERT = 'update_server'

    @cached_property
    def json(self):
        if self.request.method.lower() != 'post':
            return {}

        try:
            return json.loads(self.request.body)
        except ValueError:
            raise RequestError('invalid json in body')

    def post(self, request):
        server_fqdn = self.json.get('fqdn')
        sources_names = self.json.get('sources')
        client_version = self.json.get('client_version')
        server_type = self.json.get('type')

        if server_fqdn is None or (sources_names is None and client_version is None and server_type is None):
            return {'status': 'fail'}

        update_server_sources.delay(server_fqdn, server_type, sources_names, client_version)

        return {'status': 'ok'}
