from sqlalchemy import func

from infra.cauth.server.common.models import Server
from infra.cauth.server.common.alchemy import Session

from django.http import HttpResponse

from infra.cauth.server.master.utils.config import service_is_readonly

from .base import BaseView


class StatusView(BaseView):
    IS_READ_ONLY = True

    def get(self, request, **kwargs):
        server_count = Session.query(func.count(Server.id)).scalar()
        return {'server_count': server_count}


class PingView(BaseView):
    IS_READ_ONLY = True

    def get(self, request, **kwargs):
        if service_is_readonly():
            return HttpResponse('This instance is a slave.', status=503)
        return {'status': 'ok'}
