from django.http import HttpResponse

from infra.cauth.server.master.constants import FILE_TYPE
from infra.cauth.server.master.files.models import S3File

from .base import BaseView


class PuncherView(BaseView):
    REQUIRE_CERT = 'puncher'
    IS_READ_ONLY = True

    def get(self, *args, **kwargs):
        cache_file = S3File.objects.get_last(FILE_TYPE.PUNCHER_CACHE)

        response = HttpResponse('')
        response['X-Accel-Redirect'] = '/s3/' + cache_file.file.url
        response['Content-Type'] = 'application/json; charset=utf-8'

        return response
